function isInputWithinForm(input, form)
{
    const inputOffset = $(input).offset();
    const inputHeight = $(input).height();
    const inputWidth = $(input).width();

    const formOffset = $(form).offset();
    const formHeight = $(form).height();
    const formWidth = $(form).width();

    return  formOffset.left <= inputOffset.left &&
            formOffset.top <= inputOffset.top &&
            formOffset.left + formWidth >= inputOffset.left + inputWidth &&
            formOffset.top + formHeight >= inputOffset.top + inputHeight;
}

var FocusManager = {

    //show_kb_on_pass: true,
    focused_element: "no element",
    last_insert_length: 0,
    tabsPressed: 0,
    
    backspace: function(to_backspace)
    {
        if(typeof FocusManager.focused_element == "object")
            FocusManager.focused_element.addEventListener("blur",  FocusManager.element_blur);
        KL.callGlobalObject("transitContentCall", { name: "fmBackspacePressed", arg: ["symbol"] });
        if(typeof FocusManager.focused_element == "object")
            FocusManager.focused_element.removeEventListener("blur", FocusManager.element_blur);
    },
    
    really_backspace: function(to_backspace)
    {
        if(to_backspace == "symbol")
        {
            if(FocusManager.focused_element != "no element")
            {
                var left = FocusManager.focused_element.value.length;
                var right = FocusManager.focused_element.value.length;
                
                try {
                    if(FocusManager.focused_element.selectionStart && FocusManager.focused_element.selectionEnd) {
                        left = FocusManager.focused_element.selectionStart;
                        right = FocusManager.focused_element.selectionEnd;                        
                    }
                }
                catch (err) {
                    // 
                }
                
                // Delete selection or previous element
                if(right == left)
                    left -= 1;
                
                var a = FocusManager.focused_element.value.substring(0, left);
                var b = FocusManager.focused_element.value.substring(right, FocusManager.focused_element.value.length);
                
                FocusManager.focused_element.value = a + b;
                
                try {
                     FocusManager.focused_element.selectionStart = left;
                     FocusManager.focused_element.selectionEnd = left;
                }
                catch (err) {
                    // 
                }
            }
        }
    },

    return_pressed: function()
    {
        if(typeof FocusManager.focused_element == "object")
            FocusManager.focused_element.addEventListener("blur",  FocusManager.element_blur);
        KL.callGlobalObject("transitContentCall", { name: "fmReturnPressed", arg: [] });
        if(typeof FocusManager.focused_element == "object")
            FocusManager.focused_element.removeEventListener("blur", FocusManager.element_blur);
    },
    
    really_return_pressed: function()
    {
        setTimeout(function() {
            var foundButton = false;
            var buttonSearchSelector = 'button[id*=\'sign\'],button[class*=\'submit\'],button[class*=\'Submit\'],button[type=\'submit\'],input[type=\'submit\'],input[type=\'image\'],a[id*=\'subm\'],a[id*=\'Subm\'],div[class*=\'subm\'],div[class*=\'Subm\'],div[id*=\'subm\'],div[id*=\'Subm\'],div[id*=\'loginButton\'],div[id*=\'loginButton\']';
            $(FocusManager.focused_element).parents("form").find(buttonSearchSelector).each(function(){
                $(this).click();
                foundButton = true
            });
            if(!foundButton) {
                // Post form request
                var theForm = $(FocusManager.focused_element).closest("form")[0];
                if(typeof theForm !== 'undefined') {
                    $(theForm).submit();
                    foundButton = true;
                }                
            }
            if(!foundButton) {
                $(FocusManager.focused_element).parents("body").find(buttonSearchSelector).each(function(){
                    $(this).click();
                    foundButton = true
                });                
            }
       }, 0);
    },
    
    tab_pressed: function()
    {
        FocusManager.tabsPressed++;
        
        if(typeof FocusManager.focused_element == "object")
            FocusManager.focused_element.addEventListener("blur",  FocusManager.element_blur);            
        KL.callGlobalObject("transitContentCall", { name: "fmTabPressed", arg: [] });
        if(typeof FocusManager.focused_element == "object")            
            FocusManager.focused_element.removeEventListener("blur", FocusManager.element_blur);
    },
    
    really_tab_pressed: function()
    {
        FocusManager.tabsPressed--;
        if(FocusManager.tabsPressed) return;
        
        Keyboard.keep_kb_alive = true;
        
        var parent_form = $(FocusManager.focused_element).closest('form');
        var index_org = $("input").index($(FocusManager.focused_element));
        var cycled = false;
        
        do {
            index_org++;
            var newElement = $('input:eq(' + (index_org) + ')');
            if(typeof newElement[0] !== "undefined") {
                FocusManager.focused_element = newElement[0];
            }
            else {
                if(cycled) {
                    break;
                }
                else {
                    cycled = true;
                    index_org = -1;
                }
            }
        }
        while(!$(FocusManager.focused_element).is(":visible") ||
              $(FocusManager.focused_element).attr("type") == "hidden" ||
              $(FocusManager.focused_element).attr("type") == "checkbox" ||
              $(FocusManager.focused_element).attr("type") == "radio" ||
              $(FocusManager.focused_element).attr("type") == "file" ||
              $(FocusManager.focused_element).attr("type") == "submit");
                
        setTimeout(function() {
            FocusManager.focused_element.focus();
        }, 0);
    },
    
    really_append_text_to_last_focused: function(text)
    {
        var tmp = FocusManager.focused_element;
        // FocusManager.focused_element = FocusManager.last_focused;
        // console.log(FocusManager.focused_element);
        FocusManager.really_append_text(text);
        
        // FocusManager.focused_element = tmp;            
    },
    
    really_append_text: function(text)
    {
        if(FocusManager.focused_element != "no element")
        {
            FocusManager.focused_element.focus();                
            
            var left = FocusManager.focused_element.value.length;
            var right = FocusManager.focused_element.value.length;
            try {
                if(FocusManager.focused_element.selectionStart && FocusManager.focused_element.selectionEnd) {
                    left = FocusManager.focused_element.selectionStart;
                    right = FocusManager.focused_element.selectionEnd;                    
                }
            }
            catch (err) {
                // 
            }
            
            FocusManager.last_insert_length = text.length;
            
            var a = FocusManager.focused_element.value.substring(0, left);
            var b = FocusManager.focused_element.value.substring(right, FocusManager.focused_element.value.length);
        
            FocusManager.focused_element.value = a + text + b;
            var changeEvent = new Event("change");
            FocusManager.focused_element.dispatchEvent(changeEvent);
            var inputEvent = new Event("input");
            FocusManager.focused_element.dispatchEvent(inputEvent);
            
            //FocusManager.focused_element.select();
            try {
                 FocusManager.focused_element.selectionStart = left + FocusManager.last_insert_length;
                 FocusManager.focused_element.selectionEnd = left + FocusManager.last_insert_length;
            }
            catch (err) {
                // 
            } 
        }
    },
    
    append_text: function(text)
    {
        if(typeof FocusManager.focused_element == "object")
            FocusManager.focused_element.addEventListener("blur",  FocusManager.element_blur);            
        KL.callGlobalObject("transitContentCall", { name: "fmAppendText", arg: text });
        if(typeof FocusManager.focused_element == "object")            
            FocusManager.focused_element.removeEventListener("blur", FocusManager.element_blur);
    },
    
    element_blur: function(event)
    {
        this.focus();
    },
    
    element_focus: function(event)
    {
        if(this.type.toLowerCase() == "text"   ||
           this.type.toLowerCase() == "search" ||
           this.type.toLowerCase() == "password" ||
           this.type.toLowerCase() == "email")
        {
            if(FocusManager.focused_element != this && !Keyboard.user_moved)
            {
                Keyboard.recalculate = true;
                KL.callGlobalObject("transitContentCall", { name: "kbShouldRecalculate", arg: true });
            }
            FocusManager.last_focused = FocusManager.focused_element;
            FocusManager.focused_element = this;                                                                                                              
            if(!Keyboard.attached)
            {
                Keyboard.attached = true;
                // Keyboard.insert_keyboard($(this).parent(), "en", true);
            }
        }
        else
        {
            FocusManager.last_focused = FocusManager.focused_element;
            FocusManager.focused_element = "no element";
        }
    },

    
    parse_for_input: function()
    {
        var forms = $('input');
        
        for(var i = 0; i < forms.length; i++)
        {
            if($(forms[i]).attr("kl_vkbd_parsed") == "true") continue;
            $(forms[i]).attr("kl_vkbd_parsed", "true");
            
            forms[i].addEventListener("focus", FocusManager.element_focus);                
            forms[i].addEventListener("focus", function(e)
                                      {
                                          // console.log(e);
                                          if(KLContentObject.settings.showKbOnPass_option && (this.type.toLowerCase() == "password"))
                                          {                                                
                                            var form = $(this).parents("form").length != 0 ? $(this).parents("form")[0] : undefined;
                                            var nonoverlappingElement = form && isInputWithinForm(this, form) ? form : this;
                                            var offset = $(nonoverlappingElement).offset();
                                            
                                            KL.callGlobalObject("transitContentCall", {
                                                name: "kbAppear",
                                                arg: {
                                                    top: offset.top,    
                                                    left: offset.left,  
                                                    height: $(nonoverlappingElement).height(),
                                                    width: $(nonoverlappingElement).width(),
                                                    screenX: (window.top != window) ? e.screenX : 0,
                                                    screenY: (window.top != window) ? e.screenY : 0,
                                                    windowLocation: window.location.href
                                                }
                                            });
                                          }
                                      });
            forms[i].addEventListener("blur",  function()
                                      {
                                          FocusManager.focused_element = "no element";
                                          if(!Keyboard.keep_kb_alive) {
                                              KL.callGlobalObject("transitContentCall", { name: "kbToggle", arg: "" });
                                          }
                                          Keyboard.keep_kb_alive = false;
                                      });
            
          if($(forms[i]).is(":focus")) {
              FocusManager.focused_element = forms[i];
          }
        }
    }
    }
